/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2008 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.system.action;

import java.util.Date;

import jp.mosp.common.CommonConst;
import jp.mosp.common.action.MosPAction;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.dao.MosPUserDao;
import jp.mosp.common.dto.MosPUserDto;
import jp.mosp.system.vo.AccountMasterCardVo;

public class AccountMasterCardAction extends MosPAction {

	// R}h
	private static final String CMD_ACCOUNT_MASTER_CARD_SHOW   = "S2405";
	private static final String CMD_ACCOUNT_MASTER_CARD_SELECT = "S2406";
	private static final String CMD_ACCOUNT_MASTER_CARD_INSERT = "S2407";
	private static final String CMD_ACCOUNT_MASTER_CARD_UPDATE = "S2408";

	/**
	 * RXgN^
	 */
	public AccountMasterCardAction() {
		super();
	}

	/**
	 * ANV
	 */
	public void action() throws Exception {
		// DBRlNV擾
		getConnection();
		// SYSTEMmF
		confirmSystemAuth();
		// VO̎擾
		AccountMasterCardVo vo = new AccountMasterCardVo();
		vo.initVo(cfg, msg, cmd, aspUser, user);
		vo.setParams(request);
		// VOyуtH[hURL̐ݒ
		setVo(vo);
		setUrl(vo.getRetUrl());
		// R[hXg擾
		/*						
		 *  	2009/01/09	k.taniai	j[AWΉ
		 */
		vo.aryPltAuthority = util.combineArray(getCodeArray(CommonConst.TID_AUTHORITY), getArrangeAuthArray());
		// DTO̎擾
		MosPUserDto dto;
		Object obj = session.getAttribute(MospConst.ATT_DTO);
		dto = obj instanceof MosPUserDto ? (MosPUserDto)obj : null;
		// R}h̏
		if (cmd.equals(CMD_ACCOUNT_MASTER_CARD_SHOW)) {
			vo.setDefaultValues();
		} else if (cmd.equals(CMD_ACCOUNT_MASTER_CARD_SELECT)) {
			// DAO̐錾
			MosPUserDao dao = new MosPUserDao();
			dao.initDao(cfg, cmd, aspUser, user, conn);
			// f[^̎擾
			dto = dao.findForKey(key1);
			chkExist(dto);
			// VOɏZbg
			vo.setFields(dto);
			setMode(vo);
			// ZbVDTOZbg
			session.setAttribute(MospConst.ATT_DTO, dto);
		} else if (cmd.equals(CMD_ACCOUNT_MASTER_CARD_INSERT)) {
			// VKo^
			dto = insert(vo);
			// ZbVDTOZbg
			session.setAttribute(MospConst.ATT_DTO, dto);
		} else if (cmd.equals(CMD_ACCOUNT_MASTER_CARD_UPDATE)) {
			// XV
			dto = update(vo, dto);
			// ZbVDTOZbg
			session.setAttribute(MospConst.ATT_DTO, dto);
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}

	/**
	 * f[^}
	 * @param vo ΏVO
	 * @throws Exception
	 * @return f[^}ΏDTO
	 * @throws Exception
	 */
	private MosPUserDto insert(AccountMasterCardVo vo) throws Exception {
		// p[^̑ÓmF
		vo.validate();
		// DAȌ
		MosPUserDao dao = new MosPUserDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// ݃`FbN
		chkDuplicate(dao.findForKey(vo.getTxtUserId()), vo);
		// DTȌ
		MosPUserDto dto = new MosPUserDto();
		vo.setDtoFields(dto);
		dto.setPassword(MospUtility.getDigest(MospUtility.getDigest(dto.getUserId())));
		dto.setKCode("");
		dto.setChangePass(new Date());
		// f[^̑}
		dao.insert(dto);
		// DTO̍Ď擾
		dto = dao.findForKey(dto.getUserId());
		// R~bg
		commit();
		// bZ[Wݒ
		vo.setMessage(MospUtility.getMessage(msg, MospConst.MSG_INSERT, ""));
		return dto;
	}

	/**
	 * f[^XV
	 * @param vo ΏVO
	 * @param dto ΏDTO
	 * @return f[^}ΏDTO
	 * @throws Exception
	 */
	private MosPUserDto update(AccountMasterCardVo vo, MosPUserDto dto) throws Exception {
		// VÕ[hݒ
		setMode(vo);
		// p[^̑ÓmF
		vo.validate();
		// DAȌ
		MosPUserDao dao = new MosPUserDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// rmF
		chkExclusive(dto, dao.findForUpdate(vo.getTxtUserId()), vo);
		// DTȌ
		vo.setDtoFields(dto);
		// f[^̍XV
		dao.update(dto, true);
		// DTO̍Ď擾
		MosPUserDto retDto = dao.findForKey(dto.getUserId());
		// R~bg
		commit();
		// bZ[Wݒ
		vo.setMessage(MospUtility.getMessage(msg, MospConst.MSG_UPDATE, ""));
		return retDto;
	}

	/**
	 * [hݒ
	 * @param vo ΏVO
	 * @throws Exception
	 */
	private void setMode(AccountMasterCardVo vo) throws Exception {
		// [hݒ
		if (hasSystemAuth()) {
			vo.setMode(AccountMasterCardVo.MODE_SYSTEM);
		} else {
			vo.setMode(AccountMasterCardVo.MODE_UPDATE);
		}
	}

}
